/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.misc.ItemTerminalWidget;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketRequest;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalGui
extends AbstractContainerScreen<ItemTerminalContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/item_terminal.png");
    public List<ItemStack> currentlyCrafting;
    public EditBox search;
    private final List<Pair<ItemStack, Boolean>> sortedItems = new ArrayList<Pair<ItemStack, Boolean>>();
    private List<ItemStack> items;
    private List<ItemStack> craftables;
    private Button minusButton;
    private Button plusButton;
    private Button requestButton;
    private Button orderButton;
    private Button ascendingButton;
    private Button cancelCraftingButton;
    private String lastSearchText;
    private int requestAmount = 1;
    private int scrollOffset;
    private ItemStack hoveredCrafting;
    private boolean isScrolling;

    public ItemTerminalGui(ItemTerminalContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97726_ = 191;
        this.f_97727_ = 236;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.search = this.m_142416_(new EditBox(this.f_96547_, this.f_97735_ + this.getXOffset() + 97, this.f_97736_ + 6, 86, 8, (Component)new TextComponent("")));
        this.search.m_94182_(false);
        this.lastSearchText = "";
        if (this.items != null) {
            this.updateWidgets();
        }
        this.plusButton = this.m_142416_(new Button(this.f_97735_ + this.getXOffset() + 95 - 7 + 12, this.f_97736_ + 103, 12, 12, (Component)new TextComponent("+"), button -> {
            int modifier = ItemTerminalGui.requestModifier();
            this.requestAmount = modifier > 1 && this.requestAmount == 1 ? modifier : (this.requestAmount += modifier);
            if (this.requestAmount > 384) {
                this.requestAmount = 384;
            }
        }));
        this.minusButton = this.m_142416_(new Button(this.f_97735_ + this.getXOffset() + 95 - 7 - 24, this.f_97736_ + 103, 12, 12, (Component)new TextComponent("-"), button -> {
            this.requestAmount -= ItemTerminalGui.requestModifier();
            if (this.requestAmount < 1) {
                this.requestAmount = 1;
            }
        }));
        this.minusButton.f_93623_ = false;
        this.requestButton = this.m_142416_(new Button(this.f_97735_ + this.getXOffset() + 95 - 7 - 25, this.f_97736_ + 115, 50, 20, (Component)new TranslatableComponent("info.prettypipes.request"), button -> {
            Optional<ItemTerminalWidget> widget = this.streamWidgets().filter(w -> w.selected).findFirst();
            if (!widget.isPresent()) {
                return;
            }
            ItemStack stack = widget.get().stack.m_41777_();
            stack.m_41764_(1);
            PacketHandler.sendToServer(new PacketRequest(((ItemTerminalContainer)this.f_97732_).tile.m_58899_(), stack, this.requestAmount));
            this.requestAmount = 1;
        }));
        this.requestButton.f_93623_ = false;
        this.orderButton = this.m_142416_(new Button(this.f_97735_ - 22, this.f_97736_, 20, 20, (Component)new TextComponent(""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalItemOrder = prefs.terminalItemOrder.next();
            prefs.save();
            this.updateWidgets();
        }));
        this.ascendingButton = this.m_142416_(new Button(this.f_97735_ - 22, this.f_97736_ + 22, 20, 20, (Component)new TextComponent(""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalAscending = !prefs.terminalAscending;
            prefs.save();
            this.updateWidgets();
        }));
        this.cancelCraftingButton = this.m_142416_(new Button(this.f_97735_ + this.f_97726_ + 4, this.f_97736_ + 4 + 64, 54, 20, (Component)new TranslatableComponent("info.prettypipes.cancel_all"), b -> {}));
        this.cancelCraftingButton.f_93624_ = false;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_142416_(new ItemTerminalWidget(this.f_97735_ + this.getXOffset() + 8 + x * 18, this.f_97736_ + 18 + y * 18, x, y, this));
            }
        }
    }

    protected int getXOffset() {
        return 0;
    }

    public void m_181908_() {
        String text;
        super.m_181908_();
        this.requestButton.f_93623_ = this.streamWidgets().anyMatch(w -> w.selected);
        this.plusButton.f_93623_ = this.requestAmount < 384;
        this.minusButton.f_93623_ = this.requestAmount > 1;
        this.search.m_94120_();
        if (this.items != null && !this.lastSearchText.equals(text = this.search.m_94155_())) {
            this.lastSearchText = text;
            this.updateWidgets();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)(this.f_97735_ + this.getXOffset() + 172) && (double)this.f_97736_ + mouseY >= 18.0 && mouseX < (double)(this.f_97735_ + this.getXOffset() + 172 + 12) && mouseY < (double)(this.f_97736_ + 18 + 70)) {
            this.isScrolling = true;
            return true;
        }
        if (button == 1 && mouseX >= (double)this.search.f_93620_ && mouseX <= (double)(this.search.f_93620_ + this.search.m_5711_()) && mouseY >= (double)this.search.f_93621_ && mouseY <= (double)(this.search.f_93621_ + 8)) {
            this.search.m_94144_("");
            this.search.m_94178_(true);
            this.m_7522_((GuiEventListener)this.search);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.cancelCraftingButton.f_93624_ && this.cancelCraftingButton.m_198029_() && this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            PacketHandler.sendToServer(new PacketButton(((ItemTerminalContainer)this.f_97732_).tile.m_58899_(), PacketButton.ButtonResult.CANCEL_CRAFTING, new int[0]));
            return true;
        }
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int i, double j, double k) {
        if (this.isScrolling) {
            float percentage = Mth.m_14036_((float)(((float)mouseY - (float)(this.f_97736_ + 18) - 7.5f) / 55.0f), (float)0.0f, (float)1.0f);
            int offset = (int)(percentage * (float)(this.sortedItems.size() / 9 - 3));
            if (offset != this.scrollOffset) {
                this.scrollOffset = offset;
                this.updateWidgets();
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, i, j, k);
    }

    public boolean m_7933_(int x, int y, int z) {
        InputConstants.Key mouseKey;
        if (this.search.m_93696_() && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey = InputConstants.m_84827_((int)x, (int)y))) {
            return false;
        }
        return super.m_7933_(x, y, z);
    }

    public void updateItemList(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
        this.updateWidgets();
    }

    public void updateWidgets() {
        PlayerPrefs prefs = PlayerPrefs.get();
        this.ascendingButton.m_93666_((Component)new TextComponent(prefs.terminalAscending ? "^" : "v"));
        this.orderButton.m_93666_((Component)new TextComponent(prefs.terminalItemOrder.name().substring(0, 1)));
        this.cancelCraftingButton.f_93624_ = this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty();
        Comparator<ItemStack> comparator = prefs.terminalItemOrder.comparator;
        if (!prefs.terminalAscending) {
            comparator = comparator.reversed();
        }
        this.sortedItems.clear();
        for (ItemStack stack : this.items) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)false));
        }
        for (ItemStack stack : this.craftables) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)true));
        }
        Comparator<Pair> fullComparator = Comparator.comparing(Pair::getRight);
        this.sortedItems.sort(fullComparator.thenComparing(Pair::getLeft, comparator));
        String searchText = this.search.m_94155_();
        if (!Strings.isNullOrEmpty((String)searchText)) {
            this.sortedItems.removeIf(s -> {
                String toCompare;
                String search = searchText;
                if (search.startsWith("@")) {
                    toCompare = ((ItemStack)s.getLeft()).m_41720_().getCreatorModId((ItemStack)s.getLeft());
                    search = search.substring(1);
                } else if (search.startsWith("#")) {
                    List hoverText = ((ItemStack)s.getLeft()).m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                    toCompare = hoverText.stream().map(Component::getString).collect(Collectors.joining("\n"));
                    search = search.substring(1);
                } else {
                    toCompare = ((ItemStack)s.getLeft()).m_41786_().getString();
                }
                return !toCompare.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
            });
        }
        if (this.sortedItems.size() < 36) {
            this.scrollOffset = 0;
        }
        List widgets = this.streamWidgets().collect(Collectors.toList());
        for (int i = 0; i < widgets.size(); ++i) {
            ItemTerminalWidget widget = (ItemTerminalWidget)((Object)widgets.get(i));
            int index = i + this.scrollOffset * 9;
            if (index >= this.sortedItems.size()) {
                widget.stack = ItemStack.f_41583_;
                widget.craftable = false;
                widget.f_93624_ = false;
                continue;
            }
            Pair<ItemStack, Boolean> stack = this.sortedItems.get(index);
            widget.stack = (ItemStack)stack.getLeft();
            widget.craftable = (Boolean)stack.getRight();
            widget.f_93624_ = true;
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof ItemTerminalWidget)) continue;
            ItemTerminalWidget terminal = (ItemTerminalWidget)widget;
            terminal.m_7428_(matrix, mouseX, mouseY);
        }
        if (this.sortedItems != null) {
            PlayerPrefs prefs = PlayerPrefs.get();
            if (this.orderButton.m_198029_()) {
                this.m_96602_(matrix, (Component)new TranslatableComponent("info.prettypipes.order", new Object[]{I18n.m_118938_((String)("info.prettypipes.order." + prefs.terminalItemOrder.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.ascendingButton.m_198029_()) {
                this.m_96602_(matrix, (Component)new TranslatableComponent("info.prettypipes." + (prefs.terminalAscending ? "ascending" : "descending")), mouseX, mouseY);
            }
        }
        if (this.cancelCraftingButton.f_93624_ && this.cancelCraftingButton.m_198029_()) {
            String[] tooltip = I18n.m_118938_((String)"info.prettypipes.cancel_all.desc", (Object[])new Object[0]).split("\n");
            this.m_96597_(matrix, Arrays.stream(tooltip).map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
        }
        if (!this.hoveredCrafting.m_41619_()) {
            this.m_6057_(matrix, this.hoveredCrafting, mouseX, mouseY);
        }
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrix, this.f_169604_.getString(), (float)(8 + this.getXOffset()), (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92883_(matrix, this.f_96539_.getString(), 8.0f, 6.0f, 0x404040);
        String amount = String.valueOf(this.requestAmount);
        this.f_96547_.m_92883_(matrix, amount, (float)(191 - this.f_96547_.m_92895_(amount)) / 2.0f - 7.0f + (float)this.getXOffset(), 106.0f, 0x404040);
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            this.f_96547_.m_92883_(matrix, I18n.m_118938_((String)"info.prettypipes.crafting", (Object[])new Object[0]), (float)(this.f_97726_ + 4), 10.0f, 0x404040);
            if (this.currentlyCrafting.size() > 6) {
                this.f_96547_.m_92883_(matrix, ". . .", (float)(this.f_97726_ + 24), 55.0f, 0x404040);
            }
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.sortedItems != null && this.sortedItems.size() >= 36) {
            float percentage = (float)this.scrollOffset / (float)(this.sortedItems.size() / 9 - 3);
            this.m_93228_(matrix, this.f_97735_ + this.getXOffset() + 172, this.f_97736_ + 18 + (int)(percentage * 55.0f), 232, 241, 12, 15);
        } else {
            this.m_93228_(matrix, this.f_97735_ + this.getXOffset() + 172, this.f_97736_ + 18, 244, 241, 12, 15);
        }
        this.hoveredCrafting = ItemStack.f_41583_;
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(matrix, this.f_97735_ + this.f_97726_, this.f_97736_ + 4, 191, 0, 65, 89);
            int x = 0;
            int y = 0;
            for (ItemStack stack : this.currentlyCrafting) {
                int itemX = this.f_97735_ + this.f_97726_ + 4 + x * 18;
                int itemY = this.f_97736_ + 4 + 16 + y * 18;
                this.f_96542_.m_115123_(stack, itemX, itemY);
                this.f_96542_.m_115174_(this.f_96547_, stack, itemX, itemY, String.valueOf(stack.m_41613_()));
                if (mouseX >= itemX && mouseY >= itemY && mouseX < itemX + 16 && mouseY < itemY + 18) {
                    this.hoveredCrafting = stack;
                }
                if (++x < 3) continue;
                x = 0;
                if (++y < 2) continue;
                break;
            }
        }
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public boolean m_6050_(double x, double y, double scroll) {
        int offset;
        if (this.sortedItems != null && this.sortedItems.size() >= 36 && (offset = Mth.m_14045_((int)(this.scrollOffset - (int)Math.signum(scroll)), (int)0, (int)(this.sortedItems.size() / 9 - 3))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.updateWidgets();
        }
        return true;
    }

    public <T extends GuiEventListener & Widget> T m_142416_(T p_169406_) {
        return (T)super.m_142416_(p_169406_);
    }

    public Stream<ItemTerminalWidget> streamWidgets() {
        return this.f_169369_.stream().filter(w -> w instanceof ItemTerminalWidget).map(w -> (ItemTerminalWidget)((Object)w));
    }

    public static int requestModifier() {
        if (Screen.m_96637_()) {
            return 10;
        }
        if (Screen.m_96638_()) {
            return 64;
        }
        return 1;
    }
}

